﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FGetSundayDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FGetSundayDate]
GO

CREATE Function [dbo].[FGetSundayDate] 
(
	@year int,  -- The Year
	@month int, -- The Month
	@sundayindex int --Sunday Index 1, 2, 3, 4 and 5 for the latest 
)
returns DateTime
AS
BEGIN
	-- new version september 2013
	-- Country datefirst mod
	declare @lastSundaydatefirstMod int
	declare @firstNSundaydatefirstMod int

	if ( @@datefirst = 1 )
	begin
		set @lastSundaydatefirstMod = 0
		set @firstNSundaydatefirstMod = 7
	end
	else
	begin
		set @lastSundaydatefirstMod = 1
		set @firstNSundaydatefirstMod = 8
	end
 
	declare @thedate DateTime
	set @thedate = CONVERT(NVARCHAR(4),@year) + '-' + RIGHT('00'+CAST(@month AS VARCHAR(2)),2) + '-01T00:00:00.0'  
 
 
	declare @firstSunday datetime
	declare @returnSunday datetime
	declare @lastdayofmonth datetime
	declare @firstdayofmonth datetime
 
	set @firstdayofmonth = @thedate
 
	set @lastdayofmonth = DATEADD(MONTH,1,@firstdayofmonth) - 1
	set @lastdayofmonth = DATEADD(HOUR,23,@lastdayofmonth);
	set @lastdayofmonth = DATEADD(MINUTE,59,@lastdayofmonth);
	set @lastdayofmonth = DATEADD(SECOND,59,@lastdayofmonth);
	set @lastdayofmonth = DATEADD(MILLISECOND,990,@lastdayofmonth);

 
	declare @dayofweek int -- 1 sunday , 6 
	if ( @sundayindex < 5 )
	begin
		-- find the first n sunday
		set @dayofweek = DATEPART(dw,@firstdayofmonth);
		if ( @dayofweek = 8-@@datefirst )
			set @firstSunday = @firstdayofmonth
		else
			set @firstSunday = DATEADD(dd,@firstNSundaydatefirstMod-@dayofweek,@firstdayofmonth)
	
		set @returnSunday = DATEADD(dd,(@sundayindex-1)*7,@firstSunday)
	end
	else
	begin
		-- find the last sunday of the month
		set @dayofweek = DATEPART(dw,@lastdayofmonth);
		if ( @dayofweek =  8-@@datefirst )
			set @returnSunday = @lastdayofmonth
		else
			set @returnSunday = DATEADD(dd,@lastSundaydatefirstMod-@dayofweek,@lastdayofmonth)
	
	end
	RETURN @returnSunday
END



GO
--DE18743 - [NVW] - FromUTC and toUTC do not work with TZ that do not use DST
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_FromUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_FromUTC]
GO


CREATE FUNCTION [dbo].[VX_fn_FromUTC]
(
 @sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
 -- new version september 2018, that do not call getsundaydate whene dt
 --return the converted time base on timeZoneBias and DST of the source date
 declare @newdt datetime
 if ( @sourceDateTime > 2 )
 begin 
  -- Declare the return variable here
  declare @gmtbias float
  declare @dstbias float
  declare @stdmonth int
  declare @stdday int
  declare @dstmonth int
  declare @dstday int
  declare @dstactive bit
  declare @stddate DateTime
  declare @dstdate DateTime
  declare @sourceDateYear int

  SELECT @gmtbias = gmtbias,
    @dstbias = dstbias,
    @dstactive = dstactive,
    @stdmonth = standardmonth,
    @stdday = standardday,
    @dstmonth = dstmonth,
    @dstday = dstday
  FROM TimeZones where id = @timeZoneId

  --Get the year of the source date
  set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
  declare @isSourceDateDst bit
  set @isSourceDateDst = 0
  
  -- Determine wich one come first in the year Standard Time
  IF ( @dstbias > 0 )
  BEGIN
	  --Get StandardTime  Starting date
	  set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
	  --Get Dst Time Starting date
	  set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


	   if (  @stddate > @dstdate )
	   begin
		if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
		begin
		 set @isSourceDateDst = 1
		end
	   end
	   else
	   begin
		if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
		begin
		 set @isSourceDateDst = 0
		end
		else
		begin
		 set @isSourceDateDst = 1
		end
	   end
	  end
	  if ( @isSourceDateDst = 1 )
	   begin
	   set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
	   set @newdt = DateAdd(mi,@dstbias*60,@newdt)
	   end
	  else
	   begin
	   set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
	   end
 END
 ELSE
 BEGIN  -- (@sourceDateTime =< 2), we do not convert these date, they are flag date
	set @newdt = @sourceDateTime;
 END
 -- Return the result of the function
 RETURN @newdt
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_ToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_ToUTC]
GO


CREATE FUNCTION [dbo].[VX_fn_ToUTC]
(
 @sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
 -- new version september 2013
 --return the converted time base on timeZoneBias and DST of the source date
 declare @newdt datetime 
 if ( @sourceDateTime > 2 )
 begin
  -- Declare the return variable here
  declare @gmtbias float
  declare @dstbias float
  declare @stdmonth int
  declare @stdday int
  declare @dstmonth int
  declare @dstday int
  declare @dstactive bit
  declare @stddate DateTime
  declare @dstdate DateTime
  declare @sourceDateYear int
  SELECT @gmtbias = gmtbias,
    @dstbias = dstbias,
    @dstactive = dstactive,
    @stdmonth = standardmonth,
    @stdday = standardday,
    @dstmonth = dstmonth,
    @dstday = dstday
  FROM TimeZones where id = @timeZoneId
  --Get the year of the source date
  set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
  declare @isSourceDateDst bit
  set @isSourceDateDst = 0
  -- Determine wich one come first in the year Standard Time
  if ( @dstbias > 0 )
  begin

   --Get StandardTime  Starting date
   set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
   --Get Dst Time Starting date
   set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


   if (  @stddate > @dstdate )
   begin
    if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
    begin
     set @isSourceDateDst = 1
    end
   end
   else
   begin
    if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
    begin
     set @isSourceDateDst = 0
    end
    else
    begin
     set @isSourceDateDst = 1
    end
   end
  end
  --invert bias for "TO UTC"
  set @gmtbias = 0 - @gmtbias 
  set @dstbias = 0 - @dstbias
  if ( @isSourceDateDst = 1 )
   begin
   set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
   set @newdt = DateAdd(mi,@dstbias*60,@newdt)
   end
  else
   begin
   set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
   end
 end
 else
 begin  -- @sourceDateTime < 2, we do not convert these date, they are flag date
  set @newdt = @sourceDateTime;
 end
 -- Return the result of the function
 RETURN @newdt
END

